<?php

return [

    /*
    |--------------------------------------------------------------------------
    | 首頁
    |--------------------------------------------------------------------------
    |
    | resources/views/home.blade.php
    |
    */

    'Log in' => '登入',
    'Register' => '註冊',

    'Dashboard' => '控制面板',
    'Copyright' => '版權所有',
    'Made with' => '技術支援',
    'by' => '由',

    'HOME.MESSAGE' => '
    <p>使用<strong><a href="https://linkstack.org/">LinkStack</strong></a>，這款以隱私為重點的開源<strong>鏈接管理平台</strong>，來掌控您的在線形象。建立一個可自訂的個人資料頁面，將您<strong>所有重要的連結集中管理在一個方便的地方</strong>，讓您的觀眾享有無縫的瀏覽體驗。</p>
    ',


    /*
    |--------------------------------------------------------------------------
    | 範例頁面/首頁範例頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/demo.blade.php
    |
    */

    'Example page' => '範例頁面',


    /*
    |--------------------------------------------------------------------------
    | 驗證頁面
    |--------------------------------------------------------------------------
    |
    | 登入、註冊、忘記密碼、重設密碼等。
    | 這包括諸如密碼重設和電子郵件驗證等認證電子郵件。
    | resources/views/auth
    |
    */

    # 登入頁面
    'Sign In' => '登入',
    'Login to stay connected' => '登入以保持連線',
    'Email' => '電子郵件',
    'Password' => '密碼',
    'Remember Me' => '記住我',
    'Forgot Password?' => '忘記密碼？',
    'or sign in with other accounts?' => '或使用其他帳號登入？',
    'Don’t have an account?' => '還沒有帳號？',
    'Click here to sign up' => '點擊這裡註冊',


    # 重設密碼
    'Forgot your password?' => '忘記密碼了嗎？',
    'No problem' => '沒問題。只需告訴我們您的電子郵件地址，我們將寄送密碼重設連結給您，讓您選擇一個新密碼。',
    'Email Password Reset Link' => '寄送密碼重設連結',


    # 註冊頁面
    'Sign Up' => '註冊',
    'Register to stay connected' => '註冊以保持連線',
    'Display Name' => '顯示名稱',
    'Confirm Password' => '確認密碼',
    'Already have an account?' => '已經有帳號了嗎？',
    'Click here to sign in' => '點擊這裡登入',


    # 等待管理員驗證
    'Verification Status' => '驗證狀態',
    'auth_pending' => '您的帳號仍在等待驗證',
    'auth_unverified' => '您的帳號目前尚未驗證，需要管理員手動驗證。',
    'Log out' => '登出',


    # 密碼確認
    'auth_password' => '此為應用程式安全敏感區域，請在繼續前驗證您的密碼。',
    'Confirm' => '確認',


    # 重設密碼
    'Reset Password' => '重設密碼',
    'Enter a new password' => '輸入新密碼',


    # 測試電子郵件
    'Test E-Mail' => '測試寄送電子郵件',


    # 註冊通知電子郵件
    'A new user has registered on' => '有新使用者在此註冊',
    'and is awaiting verification' => '並正在等待驗證',
    'The user' => '該使用者',
    'with the email' => '使用電子郵件',
    'has registered a new account on' => '已在此註冊新帳號',
    'and is awaiting confirmation by an admin' => '並等待管理員確認。',
    'Click' => '點擊',
    'here' => '這裡',
    'to verify the user' => '以驗證使用者。',
    'Manage Users' => '管理使用者',


    # 電子郵件驗證電子郵件
    'auth_thanks' => '感謝您的註冊！在開始之前，您可以通過點擊我們剛剛發送給您的連結來驗證您的電子郵件地址嗎？如果您沒有收到電子郵件，我們將很樂意再次發送。如果幾分鐘內仍未收到電子郵件，請檢查您的垃圾郵件或垃圾郵件資料夾。',
    'auth_verification' => '一個新的驗證連結已發送到您在註冊期間提供的電子郵件地址。',
    'Resend Verification Email' => '重新寄送驗證電子郵件',


    /*
    |--------------------------------------------------------------------------
    | 側邊攔樣式
    |--------------------------------------------------------------------------
    |
    | resources/views/layouts/sidebar.blade.php
    |
    */

    'Settings' => '設定',
    'Scheme' => '配色方案',
    'Auto' => '自動',
    'Dark' => '深色',
    'Light' => '淺色',
    'Color Customizer' => '自訂顏色',
    'Sidebar Color' => '側邊欄顏色',
    'Default' => '預設',
    'Color' => '顏色',
    'Transparent' => '透明',
    'Sidebar Types' => '側邊欄類型',
    'Mini' => '迷你',
    'Hover' => '懸停',
    'Boxed' => '有框的',
    'Sidebar Active Style' => '側邊欄活動樣式',
    'Rounded One Side' => '單邊圓角',
    'Rounded All' => '全部圓角',
    'Pill One Side' => '單邊圓柱形',
    'Pill All' => '全部圓柱形',


    /*
    |--------------------------------------------------------------------------
    | 網站客製
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/site.blade.php
    |
    */

    'Home' => '首頁',
    'Add Link' => '新增連結',
    'Administration' => '管理',
    'Admin' => '管理員',
    'Config' => '設定',
    'Footer Pages' => '頁尾頁面',
    'Site Customization' => '網站自訂',
    'Site Logo' => '網站標誌',
    'Personalization' => '個人化',
    'Links' => '連結',
    'Appearance' => '外觀',
    'Themes' => '主題',
    'Site logo' => '網站標誌',
    'Favicon' => '網站圖示',
    'Home message' => '首頁訊息',


    /*
    |--------------------------------------------------------------------------
    | 導航欄
    |--------------------------------------------------------------------------
    |
    | resources/views/layouts/sidebar.blade.php
    |
    */

    'View Page' => '查看頁面',
    'Share your profile' => '分享您的個人檔案',
    'Share your profile:' => '分享您的個人檔案：',
    'Error sharing:' => '分享錯誤：',
    'Text copied to clipboard!' => '文字已複製到剪貼簿！',
    'Error copying text:' => '複製文字出錯：',
    'QR Code' => 'QR碼',
    'Scan QR Code' => '掃描QR碼',
    'QR code could not be generated' => '無法生成QR碼',
    'Reason:' => '原因：',

    # QR碼下拉選單
    'Close' => '關閉',
    'Dismiss' => '取消',

    # 通知下拉選單
    'All Notifications' => '所有通知',

    # 更新程式下拉選單
    'Updater' => '更新程式',
    'Beta Mode' => '測試模式',
    'Local version' => '本地版本',
    'Latest beta' => '最新測試版',
    'Run updater' => '執行更新程式',
    'Update available' => '有可用更新',
    'Up to date' => '已是最新',
    'Check again' => '再次檢查',

    # 導航欄中的使用者部分
    'Administrator' => '管理員',
    'Verified user' => '已驗證使用者',
    'User' => '使用者',
    'Profile' => '個人檔案',
    'Styling' => '樣式',
    'Logout' => '登出',


    /*
    |--------------------------------------------------------------------------
    | 控制面板頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/index.blade.php
    |
    */

    # 帶圖片的頁眉
    'Hi' => '您好',
    'stranger' => '陌生人',
    'welcome' => '歡迎來到 :appName！',
    'Set a handle' => '設定一個標識(@example)',

    # 儀表板頁面
    'Total Links:' => '鏈接總數：',
    'Link Clicks:' => '鏈接點擊數：',
    'View/Edit Links' => '查看/編輯鏈接',
    'Top Links:' => '熱門鏈接：',
    'You haven’t added any links yet' => '您還沒有添加任何鏈接。',
    'clicks' => '點擊數',
    'Clicks' => '點擊數',
    'Site statistics:' => '網站統計：',
    'Total links' => '鏈接總數',
    'Total clicks' => '點擊總數',
    'Total users' => '使用者總數',
    'Registrations:' => '註冊數：',
    'Last 30 days' => '過去30天',
    'Last 7 days' => '過去7天',
    'Last 24 hours' => '過去24小時',
    'Active users:' => '活躍使用者：',



    /*
    |--------------------------------------------------------------------------
    | 按鈕編輯器
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/button-editor.blade.php
    |
    */

    'Button Editor' => '按鈕編輯器',
    'Back' => '返回',
    'Custom Button' => '自訂按鈕',
    'CSS' => 'CSS',
    'background' => '背景',
    'gradient' => '漸變',
    'Show CSS' => '顯示CSS',
    'Custom CSS' => '自訂CSS',
    'Save' => '儲存',
    'Reset to default' => '恢復預設',
    'Result' => '結果：',
    'Custom Icon' => '自訂圖示',
    'Custom Alert' => '您的自訂圖示短代碼中未包含字串“fa-”，請始終使用如“fa-ghost”格式的圖示。',
    'cb.description.1-4' => '可以通過 Font Awesome 向按鈕添加自訂圖示。您可以使用下面列表中的任何圖示，您可以通過點擊“查看所有圖示”按鈕訪問此列表。列表中的每個圖示都有一個短代碼，您可以複製並輸入到自訂圖示欄位中。',
    'cb.description.2-4' => '每個圖示的短代碼都由前綴和主要部分組成。如果短代碼不是品牌圖示，您可以簡單地輸入格式為：fa-icon-name的代碼。“fa-...”格式在此很重要。例如“fa-code”。',
    'cb.description.3-4' => '如果短代碼是品牌圖示，重要的是在短代碼部分之前包含“fab”。同樣，“fa-...”格式在此仍然適用。例如，“fab fa-github”。',
    'cb.description.4-4' => '要為您的圖示應用顏色，您可以簡單地寫出顏色名稱或在圖示前寫下HEX值，後跟一個“;”。在這裡，將顏色放在圖示短代碼前很重要，並且顏色代碼必須以分號結束。<br>您可以在<a href="https://www.w3schools.com/cssref/css_colors.asp" target="_blank">這裡</a>找到可用顏色列表。',
    'Style' => '風格',
    'Prefix' => '前綴',
    'Icon' => '圖示',
    'Short Code' => '短代碼',
    'Regular' => '常規',
    'Brands' => '品牌',
    'Color name' => '顏色名稱',
    'Color HEX' => '顏色HEX',
    'Color HEX1' => '顏色HEX',
    'Update icon' => '更新圖示',
    'See all icons' => '查看所有圖示',



    /*
    |--------------------------------------------------------------------------
    | 編輯連結頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/edit-link.blade.php
    |
    */

    'Edit' => '編輯',
    'Add' => '新增',
    'Block' => '區塊',
    'Blocks' => '區塊：',
    'Select Block' => '選擇區塊',
    'Toggle Dropdown' => '切換下拉選單',
    'Cancel' => '取消',
    'Save and Add More' => '保存並新增更多',
    'Click to change link blocks' => '點擊更改連結區塊',
    'Click for a list of available link blocks' => '點擊查看可用連結區塊列表',


    /*
    |--------------------------------------------------------------------------
    | 連結頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/links.blade.php
    |
    */

    'My Links' => '我的連結',
    'Add new Link' => '新增連結',
    'No Link Added' => '尚未添加連結。',
    'Download' => '下載',
    'Preview' => '預覽：',
    'No compatible browser' => '您的瀏覽器不兼容',
    'Page Icons' => '頁面圖示',
    'Save links' => '儲存連結',

    # 工具提示
    'Customize' => '自訂',
    'Delete' => '刪除',
    'Clear icon cache' => '清除圖示快取',

    'confirm_delete' => '您確定要刪除 :title 嗎？',


    /*
    |--------------------------------------------------------------------------
    | “我的個人資料”/“外觀”頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/page.blade.php
    |
    */

    'My Profile' => '我的個人檔案',
    'Profile Picture' => '個人檔案圖片',
    'Page URL' => '頁面 URL',
    'Display name' => '顯示名稱',
    'Name:' => '名稱：',
    'Page Description' => '頁面描述',
    'Show checkmark' => '顯示勾選標記',
    'disableverified' => '您是已驗證使用者。此設定允許您在頁面上隱藏您的勾選標記。',
    'Show share button' => '顯示分享按鈕',
    'disablesharebutton' => '此設定允許您在頁面上隱藏分享按鈕。',
    'Open links in new tab' => '在新分頁中打開連結',
    'openlinksnewtab' => '此設定決定您的連結頁面上的連結是在同一分頁中打開還是在新分頁中打開。',


    /*
    |--------------------------------------------------------------------------
    | 個人設定頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/profile.blade.php
    |
    */

    'Account Settings' => '帳戶設定',
    'Change email' => '更改信箱',
    'Change password' => '更改密碼',
    'Export user data' => '匯出使用者資料',
    'Export your user data' => '匯出您的使用者資料以轉移到另一個實例。',
    'Export all data' => '匯出所有資料',
    'Export links only' => '僅匯出連結',
    'Import user data' => '匯入使用者資料',
    'import.user.alert' => '您確定要匯入此檔案嗎？此操作將取代您目前的所有資料，包括連結！',
    'Import your user data from another instance' => '從另一個實例匯入您的使用者資料。',
    'Import' => '匯入',
    'Delete your account' => '刪除您的帳戶',
    'You are about to delete' => '您即將刪除您的帳戶！',
    'You are about to delete This action cannot be undone' => '您即將刪除您的帳戶！此操作無法反悔。',
    'Delete account' => '刪除帳戶',

    # 警告
    'Profile updated successfully!' => '個人資料更新成功！',
    'An error occurred while updating your profile.' => '更新您的個人資料時發生錯誤。',

    'That handle has already been taken' => '該標識(@example)已被使用。',
    'The selected file must be an image' => '所選文件必須是圖片。',
    'The image must be' => '圖片必須是：',
    'The image size should not exceed 2MB' => '圖片大小不應超過2MB。',
    'Please select an image' => '請選擇一張圖片。',


    /*
    |--------------------------------------------------------------------------
    | 主题頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/theme.blade.php
    |
    */

    'Select a theme' => '選擇主題',
    'Select theme' => '選擇主題',
    'Custom background' => '自訂背景',
    'No image selected' => '未選擇圖片',
    'Remove background' => '移除背景',
    'Manage themes' => '管理主題',
    'Loading...' => '載入中...',
    'Upload themes' => '上傳主題',
    'Delete themes' => '刪除主題',
    'Download themes' => '下載主題',
    'Delete a theme' => '刪除一個主題',


    /*
    |--------------------------------------------------------------------------
    | 主题更新器
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/theme-updater.blade.php
    |
    */

    'Theme Updater' => '主題更新程式',
    'Theme name' => '主題名稱：',
    'Update status' => '更新狀態：',
    'Version' => '版本：',
    'Error!' => '錯誤！',
    'Update manually' => '手動更新',
    'Update all themes' => '更新所有主題',


    /*
    |--------------------------------------------------------------------------
    | 編輯使用者頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/edit-user.blade.php
    |
    */

    'Edit User' => '編輯使用者',
    'Logo' => '標誌',
    'Page description' => '頁面描述',
    'Role' => '角色',

    /*
    |--------------------------------------------------------------------------
    | 連結頁面（管理員）
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/links.blade.php
    |
    */

    'Title' => '標題',


    /*
    |--------------------------------------------------------------------------
    | 連結頁面 (管理員)
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/links.blade.php
    |
    */

    'Link' => '連結',


    /*
    |--------------------------------------------------------------------------
    | PHP 設定頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/phpinfo.blade.php
    |
    */

    'Information about PHP’s configuration' => '關於 PHP 配定的資訊',
    'Outputs information about the current state of PHP' => '輸出有關當前 PHP 狀態的資訊',


    /*
    |--------------------------------------------------------------------------
    | 刪除主題頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/theme.blade.php
    |
    */

    'Delete theme' => '刪除主題',


    /*
    |--------------------------------------------------------------------------
    | 管理使用者頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/users.blade.php
    |
    */

    'Users:' => '使用者：',
    'Search user' => '搜尋使用者',
    'ID' => 'ID',
    'Name' => '姓名',
    'E-Mail' => '電子郵件',
    'Page' => '頁面',
    'Created at' => '建立於',
    'Last seen' => '最後登入',
    'Status' => '狀態',
    'Action' => '動作',
    'N/A' => '不適用',
    'Pending' => '待審核',
    'Verified' => '已驗證',
    'Approved' => '已核准',
    'Add new user' => '新增使用者',

    # 工具提示
    'tt.Delete' => '刪除',
    'tt.Impersonate' => '模擬',
    'tt.Edit' => '編輯',
    'tt.All links' => '所有連結',

    'confirm.delete.user' => '您確定要刪除這個使用者嗎？\n此操作無法反悔！',

    # 日期格式
    'date.format' => 'Y/m/d',

    'days ago' => '天前',
    '1 day ago' => '1 天前',
    'Today' => '今天',
    '1 year ago' => '1 年前',
    'years ago' => '年前',


    /*
    |--------------------------------------------------------------------------
    | 設定頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/components/config/
    | resources/views/panel/config-editor.blade.php
    |
    */

    'Advanced Config' => '進階設定',
    'Take Backup' => '備份',
    'All Backups' => '所有備份',
    'Diagnosis' => '診斷',

    'Alternative Config Editor' => '替代設定編輯器',
    'Use the Alternative Config Editor to edit the config directly' => '使用替代設定編輯器直接編輯設定',

    'PHP info' => 'PHP資訊',
    'Display debugging information about your PHP setup' => '顯示有關您的PHP設置的除錯信息',

    'Jump directly to:' => '直接跳至：',

    'Application' => '應用程式',
    'Panel settings' => '面板設定',
    'Security' => '安全性',
    'Advanced' => '進階',
    'SMTP' => 'SMTP',
    'Footer links' => '頁尾連結',
    'Debug' => '偵錯',
    'Language' => '語言',

    'default' => '預設',
    'Apply' => '套用',

    'AC.description' => '允許編輯您的網站前端。此文件允許自定義首頁、連結、標題、Google分析和元標籤等內容。',
    'Advanced Configuration file.' => '高級設定檔。',
    'Restore defaults' => '恢復預設值',

    'Backup' => '備份',
    'You can back up your entire instance:' => '您可以備份整個實例：',
    'The backup system won’t save more than two backups at a time' => '備份系統一次不會保存超過兩個備份。',
    'Backup Instance' => '備份實例',

    'wtrue' => '一切運行正常！',
    'wfalse' => '此文件無法寫入。這可能妨礙正常運行。',
    'utrue' => '您的安全處於風險中。此文件可以被所有人訪問。需要立即採取行動！',
    'ufalse' => '一切運行正常！',
    'unull' => '出現了一些問題。如果您在代理或Docker容器後面運行，這可能是正常的。',
    'Debugging information' => '除錯信息',
    'security.risk' => '您的安全處於風險中。某些文件可以被所有人訪問。需要立即採取行動！點擊此消息瞭解更多。',
    'security.risk.1-3' => '在這裡，您可以輕鬆驗證是否可以從外部訪問關鍵系統文件。重要的是這些文件不能被訪問，否則像密碼這樣的用戶數據可能會洩露。標有',
    'security.risk.2-3' => '的條目不能從外部訪問，標有',
    'security.risk.3-3' => '的條目可以被任何人訪問，需要立即採取行動以保護您的數據。',
    'Hover for more' => '懸停以獲得更多信息',
    'Write access' => '寫入許可權',
    'Write access.description.1-3' => '在這裡，您可以輕鬆驗證是否可以寫入重要的系統文件。這對於每個功能的正常工作都很重要。標有',
    'Write access.description.2-3' => '的條目按預期工作，標有',
    'Write access.description.3-3' => '的條目不行。',
    'File' => '文件',
    'Dependencies' => '依賴項',
    'Required PHP modules' => '所需的 PHP 模組。',
    'PHP Extension' => 'PHP 擴展',
    'No backups found' => '未找到備份',
    'Backup your instance' => '備份您的實例',

    'Go back' => '返回',

    'Strings with a # in front of them are comments and wont affect anything' => '前面有 # 的字串是註解，不會影響任何事情。',

    'Download your updater backups:' => '下載您的更新備份：',
    'The server will never store more that two backups at a time' => '伺服器一次最多只會存儲兩個備份。',

    'SMTP.title' => '使用內建SMTP伺服器',
    'SMTP.description' => '使用由LinkStack提供的SMTP伺服器。可能不是100%可靠。必須禁用它才能使用自定義SMTP伺服器。',
    'SMTP.description.alt' => '（在下方用“應用更改”保存更改）',
    'Enable' => '啟用',
    'Custom SMTP server:' => '自定義SMTP伺服器：',
    'Host' => '主機',
    'Port' => '埠號',
    'Username' => '使用者名稱',
    'Encryption type' => '加密類型',
    'From address' => '寄件人地址',
    'Apply changes' => '應用更改',
    'Test E-Mail setup:' => '測試電子郵件設置：',
    'Send Test E-Mail' => '發送測試電子郵件',

    'Debug.title' => '除錯模式',
    'Debug.description' => '在生產環境中應該禁用。在設置過程中用於除錯。',

    'DISPLAY_FOOTER_HOME.title' => '首頁頁尾連結',
    'DISPLAY_FOOTER_HOME.description' => '啟用首頁頁尾連結。',
    'REGISTER_AUTH.title' => '啟用電子郵件驗證',
    'REGISTER_AUTH.description' => '決定使用者註冊時是否必須驗證其電子郵件。',
    'ALLOW_REGISTRATION.title' => '啟用註冊',
    'ALLOW_REGISTRATION.description' => '決定使用者是否可以註冊您的應用程式。',
    'NOTIFY_EVENTS.title' => '通知事件',
    'NOTIFY_EVENTS.description' => '如果有事件正在進行，則顯示通知。',
    'NOTIFY_UPDATES.title' => '通知更新',
    'NOTIFY_UPDATES.description' => '如果有新的更新可用，則顯示通知。',
    'DISPLAY_FOOTER.title' => '顯示頁尾',
    'DISPLAY_FOOTER.description' => '決定是否應顯示頁尾連結。',
    'DISPLAY_CREDIT.title' => '在使用者頁面顯示信用',
    'DISPLAY_CREDIT.description' => '決定是否應在使用者頁面上顯示信用通知。',
    'DISPLAY_CREDIT_FOOTER.title' => '在頁尾中顯示信用',
    'DISPLAY_CREDIT_FOOTER.description' => '決定是否應在頁尾中顯示信用通知。',
    'HOME_URL.title' => '將使用者頁面設為首頁',
    'HOME_URL.description' => '將一個使用者頁面設為首頁。這將把之前的首頁移動到example.com/home。',
    'ALLOW_USER_HTML.title' => '允許在使用者的描述中使用擴展語法',
    'ALLOW_USER_HTML.description' => '這使得使用者能夠在其頁面描述中使用特殊格式，如標題和連結。<br>這通常被認為是安全的。',
    'APP_NAME.title' => '應用程式名稱',
    'APP_NAME.description' => '設定您的應用程式名稱。更改將登出每個活躍使用者。',
    'APP_KEY.title' => 'APP_KEY',
    'APP_KEY.description' => 'APP_KEY',
    'APP_URL.title' => 'APP_URL',
    'APP_URL.description' => 'APP_URL',
    'ENABLE_BUTTON_EDITOR.title' => '啟用按鈕編輯器',
    'ENABLE_BUTTON_EDITOR.description' => '決定是否允許使用者使用CSS自定義他們自己的按鈕。',
    'APP_DEBUG.title' => 'APP_DEBUG',
    'APP_DEBUG.description' => 'APP_DEBUG',
    'APP_ENV.title' => 'APP_ENV',
    'APP_ENV.description' => 'APP_ENV',
    'LOG_CHANNEL.title' => 'LOG_CHANNEL',
    'LOG_CHANNEL.description' => 'LOG_CHANNEL',
    'LOG_LEVEL.title' => 'LOG_LEVEL',
    'LOG_LEVEL.description' => 'LOG_LEVEL',
    'MAINTENANCE_MODE.title' => '啟用維護模式',
    'MAINTENANCE_MODE.description' => '在所有公共頁面上顯示維護訊息。這將禁用登錄頁面。',
    'MAIL_MAILER.title' => 'MAIL_MAILER',
    'MAIL_MAILER.description' => 'MAIL_MAILER',
    'MAIL_HOST.title' => 'MAIL_HOST',
    'MAIL_HOST.description' => 'MAIL_HOST',
    'MAIL_PORT.title' => 'MAIL_PORT',
    'MAIL_PORT.description' => 'MAIL_PORT',
    'MAIL_USERNAME.title' => 'MAIL_USERNAME',
    'MAIL_USERNAME.description' => 'MAIL_USERNAME',
    'MAIL_PASSWORD.title' => 'MAIL_PASSWORD',
    'MAIL_PASSWORD.description' => 'MAIL_PASSWORD',
    'MAIL_ENCRYPTION.title' => 'MAIL_ENCRYPTION',
    'MAIL_ENCRYPTION.description' => 'MAIL_ENCRYPTION',
    'MAIL_FROM_ADDRESS.title' => 'MAIL_FROM_ADDRESS',
    'MAIL_FROM_ADDRESS.description' => 'MAIL_FROM_ADDRESS',
    'JOIN_BETA.title' => '加入測試版計畫',
    'JOIN_BETA.description' => '在更新時啟用測試版的使用。在<a target=\'_blank\' href=\'https://linkstack.org/b\'>這裡</a>了解更多。',
    'SKIP_UPDATE_BACKUP.title' => '略過更新備份',
    'SKIP_UPDATE_BACKUP.description' => '在更新時略過備份。建議始終停用此選項，<br>但在某些配置中可能會導致錯誤。',
    'CUSTOM_META_TAGS.title' => '啟用自訂元標籤',
    'CUSTOM_META_TAGS.description' => '在所有頁面的頭部啟用自訂元標籤的使用。在高級配置中定義。',
    'FORCE_HTTPS.title' => '強制使用HTTPS連線',
    'FORCE_HTTPS.description' => '預設情況下使所有連線使用HTTPS。如果您使用反向代理，建議啟用此選項。',
    'ALLOW_CUSTOM_CODE_IN_THEMES.title' => '允許在佈景主題中使用自訂程式碼',
    'ALLOW_CUSTOM_CODE_IN_THEMES.description' => '允許在佈景主題中使用自訂程式碼。如果您使用來自未知來源的佈景主題，<br>這可能構成安全風險。',
    'ENABLE_ADMIN_BAR_USERS.title' => '為所有使用者啟用管理員工具列',
    'ENABLE_ADMIN_BAR_USERS.description' => '如果啟用，所有經過身份驗證的使用者都將在其頁面上顯示管理員工具列。',
    'ENABLE_THEME_UPDATER.title' => '啟用佈景主題更新器',
    'ENABLE_THEME_UPDATER.description' => '決定佈景主題更新器是否應處於活動狀態。',
    'ENABLE_SOCIAL_LOGIN.title' => '啟用社交登入',
    'ENABLE_SOCIAL_LOGIN.description' => '啟用社交登入。此選項需要進一步設定。在<a target=\'_blank\' href=\'https://linkstack.org/social-login\'>這裡</a>了解更多。',
    'USE_THEME_PREVIEW_IFRAME.title' => '使用 iframe 作為佈景主題預覽',
    'USE_THEME_PREVIEW_IFRAME.description' => '決定是否應使用內部 iframe 作為佈景主題頁面的預覽。',
    'FORCE_ROUTE_HTTPS.title' => '將所有頁面重定向到 HTTPS',
    'FORCE_ROUTE_HTTPS.description' => '如果使用反向代理，此選項將破壞您的設定。',
    'DISPLAY_FOOTER_TERMS.title' => '條款頁尾連結',
    'DISPLAY_FOOTER_TERMS.description' => '啟用條款頁尾連結。',
    'DISPLAY_FOOTER_PRIVACY.title' => '隱私頁尾連結',
    'DISPLAY_FOOTER_PRIVACY.description' => '啟用隱私頁尾連結。',
    'DISPLAY_FOOTER_CONTACT.title' => '聯絡頁尾連結',
    'DISPLAY_FOOTER_CONTACT.description' => '啟用聯絡頁尾連結。',
    'TITLE_FOOTER_HOME.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_HOME.description' => '首頁頁腳連結的標題。',
    'TITLE_FOOTER_TERMS.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_TERMS.description' => '條款頁腳連結的標題。',
    'TITLE_FOOTER_PRIVACY.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_PRIVACY.description' => '隱私頁腳連結的標題。',
    'TITLE_FOOTER_CONTACT.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_CONTACT.description' => '聯絡頁腳連結的標題。',
    'HOME_FOOTER_LINK.title' => '<div style="margin-top:-40px">首頁頁腳連結網址</div>',
    'HOME_FOOTER_LINK.description' => '輸入任何網址以重新導向您的首頁連結網址。<br>留空使用預設連結。',
    'ALLOW_CUSTOM_BACKGROUNDS.title' => '允許自訂背景',
    'ALLOW_CUSTOM_BACKGROUNDS.description' => '允許使用者上傳自訂背景圖片至其頁面。',
    'ALLOW_USER_IMPORT.title' => '允許使用者從其他實例匯入設定檔',
    'ALLOW_USER_IMPORT.description' => '允許使用者從外部檔案匯入其設定檔和連結。',
    'ALLOW_USER_EXPORT.title' => '允許使用者匯出其設定檔',
    'ALLOW_USER_EXPORT.description' => '允許使用者匯出其自己的連結和設定檔。',
    'MANUAL_USER_VERIFICATION.title' => '手動驗證使用者',
    'MANUAL_USER_VERIFICATION.description' => '決定管理員是否必須手動驗證新註冊的使用者。',
    'ADMIN_EMAIL.title' => '管理員電子郵件',
    'ADMIN_EMAIL.description' => '用於發送通知電子郵件。',
    'HIDE_VERIFICATION_CHECKMARK.title' => '隱藏驗證勾選標記',
    'HIDE_VERIFICATION_CHECKMARK.description' => '隱藏在管理員和VIP頁面上顯示的驗證徽章。',
    'ENABLE_REPORT_ICON.title' => '啟用報告圖示',
    'ENABLE_REPORT_ICON.description' => '在使用者頁面上顯示一個圖示，允許使用者舉報頁面。',
    'LOCALE.title' => '應用程式區域設置',
    'LOCALE.description' => '更改您的應用程式的語言',


    /*
    |--------------------------------------------------------------------------
    | 安装
    |--------------------------------------------------------------------------
    |
    | resources/views/installer/installer.blade.php
    |
    */

    # 標題標籤
    'LinkStack setup' => 'LinkStack 設置',

    'Setup LinkStack' => '設置 LinkStack',
    'Welcome to the setup for LinkStack!' => '歡迎使用 LinkStack 設置！',
    'This setup will:' => '本設置將：',
    'Check the server dependencies' => '1. 檢查伺服器相依性',
    'Setup the database' => '2. 設置資料庫',
    'Create the admin user' => '3. 建立管理員使用者',
    'Configure the app' => '4. 配置應用程式',
    'Choose a language' => '選擇語言',
    'setup.disclaimer' => '繼續即表示您同意遵守我們的',
    'Terms and Conditions' => '條款和條件',

    'Next' => '下一步',
    'Yes' => '是',
    'No' => '否',
    'Finish setup' => '完成設置',

    'Setup failed' => '設置失敗',
    'An error has occured. Please try again' => '發生錯誤，請重試',
    'Depending on your database type:' => '根據您的資料庫類型：',
    'Try again' => '重試',

    'Dependency check' => '相依性檢查',
    'Required PHP modules:' => '所需 PHP 模組：',

    'Select a database type' => '選擇資料庫類型',
    'Under most circumstances, we recommend using SQLite' => '在大多數情況下，我們建議使用 SQLite',
    'MySQL requires a separate, empty MySQL database' => 'MySQL 需要一個獨立的、空的 MySQL 資料庫',

    'Database type:' => '資料庫類型：',
    'Database host:' => '資料庫主機：',
    'Database port:' => '資料庫埠：',
    'Database name:' => '資料庫名稱：',
    'Database username:' => '資料庫使用者名稱：',
    'Database password:' => '資料庫密碼：',

    'Create an admin account' => '建立管理員帳戶',
    'Admin email:' => '管理員電子郵件：',
    'Admin password:' => '管理員密碼：',
    'Handle:' => '使用者名稱：',
    'Name:' => '姓名：',

    'Configure your page' => '配置您的頁面',
    'Enable registration:' => '啟用註冊：',
    'Enable email verification:' => '啟用電子郵件驗證：',
    'Set your page as Home Page' => '將您的頁面設置為首頁',
    'This will move the Home Page to /home' => '這將把首頁移至 /home',
    'App Name:' => '應用程式名稱：',


    /*
    |--------------------------------------------------------------------------
    | 升级步驟/升級備份
    |--------------------------------------------------------------------------
    |
    | resources/views/update.blade.php
    |
    */

    # 標題標籤
    'Update LinkStack' => '更新 LinkStack',

    'Latest beta version' => '最新測試版',
    'Installed beta version' => '已安裝測試版',
    'none' => '無',
    'You need to update to the latest mainline release' => '您需要更新到最新的主線版本',
    'You’re running the latest mainline release' => '您正在運行最新的主線版本',

    'update.manually' => '您可以自動更新您的安裝，也可以下載更新並手動安裝：',
    'update.windows' => 'Windows 使用者可以使用替代升級程序。此升級程序不會創建備份。請謹慎使用。',
    'Update automatically' => '自動更新',

    'Updating' => '正在更新',
    'Creating backup' => '建立備份',
    'Preparing update' => '準備更新',
    'No new version' => '沒有新版本',
    'There is no new version available' => '沒有可用的新版本',
    'Admin Panel' => '管理員面板',
    'Finishing up' => '完成',
    'Success!' => '成功！',
    'The update was successful' => '更新成功，您現在可以返回管理員面板。',
    'View the release notes' => '查看發布說明',
    'Run again' => '重新執行',
    'Error' => '錯誤',
    'Something went wrong with the update' => '更新過程中出現了問題',


    /*
    |--------------------------------------------------------------------------
    | 備份
    |--------------------------------------------------------------------------
    |
    | resources/views/backup.blade.php
    |
    */

    # 標題標籤
    'Backup.title' => '備份',

    'The backup was successful' => '備份成功，您現在可以返回管理員面板或查看您的所有備份。',


    /*
    |--------------------------------------------------------------------------
    | 頁面區塊
    |--------------------------------------------------------------------------
    |
    | 部分內容儲存在資料庫內。
    | resources/views/studio/edit-link.blade.php
    |
    */

    # 预設
    'block.title.predefined' => '預設網站',
    'block.description.predefined' => '從預設網站列表中選擇，並使用該網站的品牌顏色和圖示自動為您的連結設置樣式。',

    # 連結
    'block.title.link' => '自訂連結',
    'block.description.link' => '建立一個指向任何網站的自訂連結。自訂按鈕樣式和圖示，或使用網站的站點圖示作為按鈕圖示。',

    # 電子名片
    'block.title.vcard' => '電子名片',
    'block.description.vcard' => '建立或上傳電子名片。',

    # 電子郵件
    'block.title.email' => '電子郵件地址',
    'block.description.email' => '新增一個電子郵件地址，以開啟系統對話方塊來編寫新電子郵件。',

    # 電話
    'block.title.telephone' => '電話號碼',
    'block.description.telephone' => '新增一個電話號碼，以開啟系統對話方塊來撥打電話。',

    # 標題
    'block.title.heading' => '標題',
    'block.description.heading' => '使用標題來組織您的連結並將它們分為不同的組。',

    # 間距
    'block.title.spacer' => '間距',
    'block.description.spacer' => '在連結列表中添加空白空間。您可以選擇間距的高度。',

    # 文字
    'block.title.text' => '文字',
    'block.description.text' => '在您的頁面上添加不可點擊的靜態文字。',


    /*
    |--------------------------------------------------------------------------
    | 頁面項目
    |--------------------------------------------------------------------------
    |
    | resources/views/components/pageitems/
    |
    */

    'Default Email' => '預設電子郵件',
    'Custom Title' => '自訂標題',
    'Leave blank for default title' => '若要使用預設標題，請留空',
    'E-Mail address' => '電子郵件地址',
    'Enter your E-Mail' => '輸入您的電子郵件',
    
    'Heading Text:' => '標題文字：',
    
    'URL' => '網址',
    'Show website icon on button' => '在按鈕上顯示網站圖示',
    
    'Select a predefined site' => '選擇預定義網站',
    'Enter the link URL' => '輸入連結網址',
    
    'Spacing height' => '間距高度',
    
    'Phone' => '電話',
    'Telephone number' => '電話號碼',
    'Enter your telephone number' => '輸入您的電話號碼',
    
    'Text to display' => '要顯示的文字',
    
    'Vcard' => '電子名片',
    'First Name' => '名字',
    'Middle Name' => '中間名',
    'Last Name' => '姓氏',
    'Suffix' => '後綴',
    'Work' => '工作',
    'Organization' => '組織',
    'Work URL' => '工作網址',
    'Emails' => '電子郵件',
    'Enter your personal email' => '輸入您的個人電子郵件',
    'Work Email' => '工作電子郵件',
    'Enter your work email' => '輸入您的工作電子郵件',
    'Phones' => '電話',
    'Home Phone' => '家庭電話',
    'Work Phone' => '工作電話',
    'Cell Phone' => '手機',
    'Home Address' => '家庭地址',
    'Label' => '標籤',
    'Street' => '街道',
    'City' => '城市',
    'State/Province' => '州/省',
    'Zip/Postal Code' => '郵遞區號',
    'Country' => '國家',
    'Work Address' => '工作地址',
    
    'URL to the video' => '影片的網址',    


    /*
    |--------------------------------------------------------------------------
    | 維護頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/maintenance.blade.php
    |
    */

    'Maintenance Mode' => '維護模式',
    'We are performing scheduled site maintenance at this time' => '我們目前正在進行定期的網站維護。',
    'Please check back with us later' => '請稍後再回來查看。',
    'Admin options:' => '管理員選項：',
    'Turn off' => '關閉',
    'Warn.Disable.Maintenance' => '您即將關閉維護模式。您確定嗎？',    


    /*
    |--------------------------------------------------------------------------
    | LinkStack (Links) 頁面
    |--------------------------------------------------------------------------
    |
    | resources/views/linkstack/linkstack.blade.php
    |
    */

    'Share this page' => '分享此頁面',
    'Share' => '分享',
    'Copy URL to clipboard' => '複製網址到剪貼簿',
    'URL has been copied to your clipboard!' => '網址已複製到您的剪貼簿！',
    
    'Delete User' => '刪除使用者',
    'Block User' => '封鎖使用者',
    'Users Theme' => '使用者主題',
    'Search User' => '搜尋使用者',
    
    'Edit my profile' => '編輯我的個人資料',    


    /*
    |--------------------------------------------------------------------------
    | 頁腳
    |--------------------------------------------------------------------------
    |
    | 添加到某些頁面的底部。
    | resources/views/layouts/footer.blade.php
    |
    */

    'Learn more about LinkStack' => '了解更多關於 LinkStack',
    'Learn more' => '了解更多',

    /*
    |--------------------------------------------------------------------------
    | 通知消息
    |--------------------------------------------------------------------------
    |
    | 所有内部通知。
    | resources/views/layouts/notifications.blade.php
    |
    */

    'No notifications' => '没有通知',

    # 安全風險通知
    'Your security is at risk!' => '您的安全受到威脅！',
    'Immediate action is required!' => '需要立即行動！',
    'security.msg1' => '您的安全受到威脅。',
    'security.msg2' => '某些檔案可被所有人存取。需要立即採取行動！',
    'security.msg3' => '一些重要檔案可公開存取，可能危及您的安全。請立即採取行動，撤銷對這些檔案的公開存取，以防止未經授權存取您的敏感資訊。',
    'security.msg4' => '了解更多',

    # 帮助我們通知
    'Hide this notification' => '隱藏此通知',
    'Help Us Out' => '幫助我們',
    'Enjoying Linkstack?' => '喜歡使用 Linkstack 嗎？',
    'Support Linkstack' => '支持 Linkstack',
    'support.msg1' => '如果您喜歡使用 Linkstack，我們將非常感激您如果您能花一點時間',
    'support.msg2' => '在 GitHub 上給我們的專案一個星',
    'support.msg3' => '您的支持將幫助我們吸引更廣泛的受眾，提高我們專案的品質。',
    'support.msg4' => '如果您能',
    'support.msg5' => '提供財政支持</a>，哪怕是一點點，也將有助於我們支付維護和改進 Linkstack 的成本。',
    'support.msg6' => '感謝您的支持，以及您是 LinkStack 社群的一部分！',


    /*
    |--------------------------------------------------------------------------
    | 頁腳連結
    |--------------------------------------------------------------------------
    |
    */

    'footer.Home' => '首頁',
    'footer.Terms' => '條款',
    'footer.Privacy' => '隱私',
    'footer.Contact' => '聯繫',


    /*
    |--------------------------------------------------------------------------
    | 檢舉頁面
    |--------------------------------------------------------------------------
    |
    */

    'report_violation' => '檢舉違規行為',
    'url_label' => '您要檢舉的網站網址',
    'report_type_label' => '檢舉類型',
    'hate_speech' => '仇恨言論或騷擾',
    'violence_threats' => '暴力或威脅',
    'illegal_activities' => '非法活動',
    'copyright_infringement' => '侵犯版權',
    'misinformation_fake_news' => '虛假資訊或假新聞',
    'identity_theft' => '身份盜用',
    'drug_related_content' => '與藥物相關的內容',
    'weapons_harmful_objects' => '武器或有害物品',
    'child_exploitation' => '兒童剝削',
    'fraud_scams' => '詐騙或騙局',
    'privacy_violation' => '侵犯隱私',
    'impersonation' => '冒充',
    'other_specify' => '其他（請具體說明）',
    'additional_comments_label' => '附加評論',
    'submit_button' => '提交',


    'report_mail_admin_subject' => '個人檢舉',
    'report_mail_admin_report' => '已檢舉個人資料',

    'report_mail_reported_profile' => '被檢舉的個人資料',
    'report_mail_reported_url' => '被檢舉的網址',
    'report_mail_type' => '類型',
    'report_mail_message' => '訊息',

    'report_mail_report_submitted_by' => '檢舉人',
    'report_mail_reported_by' => '被檢舉人',
    'report_mail_profile' => '個人資料',

    'report_mail_button_profile' => '在使用者頁面上查看',
    'report_mail_button_delete' => '刪除被檢舉使用者',


    'report_error' => '個人資料無法被檢舉',
    'report_success' => '個人資料已成功檢舉',


    #=============================================================================#
    # Laravel 內部翻譯                                                             #
    #=============================================================================#


    /*
    |--------------------------------------------------------------------------
    | 認證語言線
    |--------------------------------------------------------------------------
    |
    | 以下語言線用於過程中的各種消息，我們需要向使用者顯示這些內容。
    | 您可以根據您的應用程序要求自由修改這些語言線。
    |
    |
    */

    'failed' => '這些認證與我們的記錄不符。',
    'password' => '提供的密碼不正確。',
    'throttle' => '登入嘗試次數過多。請在 :seconds 秒後重試。',


    /*
    |--------------------------------------------------------------------------
    | 分頁語言線
    |--------------------------------------------------------------------------
    |
    | 以下語言線由分頁器庫用於構建簡單的分頁鏈接。
    | 您可以根據您的應用程序要求更改它們以更好地匹配您的視圖。
    |
    |
    */

    'previous' => '&laquo; 上一頁',
    'next' => '下一頁 &raquo;',


];
